/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.trains.station;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.trains.station.AbstractStationScreen;
import com.zurrtum.create.client.content.trains.station.StationScreen;
import com.zurrtum.create.client.content.trains.station.WideIconButton;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.entity.TrainIconType;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.infrastructure.packet.c2s.StationEditPacket;
import com.zurrtum.create.infrastructure.packet.c2s.TrainEditPacket;
import java.lang.ref.WeakReference;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class AssemblyScreen
extends AbstractStationScreen {
    private IconButton quitAssembly;
    private IconButton toggleAssemblyButton;
    private List<class_2960> iconTypes;
    private ScrollInput iconTypeScroll;

    public AssemblyScreen(StationBlockEntity be, GlobalStation station) {
        super(be, station);
        this.background = AllGuiTextures.STATION_ASSEMBLING;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int x = this.guiLeft;
        int y = this.guiTop;
        int by = y + this.background.getHeight() - 24;
        class_4068 widget = (class_4068)this.field_33816.getFirst();
        if (widget instanceof IconButton) {
            IconButton ib = (IconButton)widget;
            ib.setIcon(AllIcons.I_PRIORITY_VERY_LOW);
            ib.setToolTip((class_2561)CreateLang.translateDirect("station.close", new Object[0]));
        }
        this.iconTypes = TrainIconType.ALL.keySet().stream().toList();
        this.iconTypeScroll = new ScrollInput(x + 4, y + 17, 162, 14).titled(CreateLang.translateDirect("station.icon_type", new Object[0]));
        this.iconTypeScroll.withRange(0, this.iconTypes.size());
        this.iconTypeScroll.withStepFunction(ctx -> -this.iconTypeScroll.standardStep().apply((ScrollValueBehaviour.StepContext)ctx).intValue());
        this.iconTypeScroll.calling(s -> {
            Train train = (Train)this.displayedTrain.get();
            if (train != null) {
                train.icon = TrainIconType.byId(this.iconTypes.get((int)s));
            }
        });
        this.iconTypeScroll.field_22764 = false;
        this.iconTypeScroll.field_22763 = false;
        this.method_37063(this.iconTypeScroll);
        this.toggleAssemblyButton = new WideIconButton(x + 94, by, AllGuiTextures.I_ASSEMBLE_TRAIN);
        this.toggleAssemblyButton.field_22763 = false;
        this.toggleAssemblyButton.setToolTip((class_2561)CreateLang.translateDirect("station.assemble_train", new Object[0]));
        this.toggleAssemblyButton.withCallback(() -> this.field_22787.field_1724.field_3944.method_52787((class_2596)StationEditPacket.tryAssemble(this.blockEntity.method_11016())));
        this.quitAssembly = new IconButton(x + 73, by, AllIcons.I_DISABLE);
        this.quitAssembly.field_22763 = true;
        this.quitAssembly.setToolTip((class_2561)CreateLang.translateDirect("station.cancel", new Object[0]));
        this.quitAssembly.withCallback(() -> {
            this.field_22787.field_1724.field_3944.method_52787((class_2596)StationEditPacket.configure(this.blockEntity.method_11016(), false, this.station.name, null));
            this.field_22787.method_1507((class_437)new StationScreen(this.blockEntity, this.station));
        });
        this.method_37063(this.toggleAssemblyButton);
        this.method_37063(this.quitAssembly);
        this.tickTrainDisplay();
    }

    @Override
    public void method_25393() {
        super.method_25393();
        this.tickTrainDisplay();
        Train train = (Train)this.displayedTrain.get();
        boolean bl = this.toggleAssemblyButton.field_22763 = this.blockEntity.bogeyCount > 0 || train != null;
        if (train != null) {
            this.field_22787.field_1724.field_3944.method_52787((class_2596)StationEditPacket.configure(this.blockEntity.method_11016(), false, this.station.name, null));
            this.field_22787.method_1507((class_437)new StationScreen(this.blockEntity, this.station));
            for (Carriage carriage : train.carriages) {
                carriage.updateConductors();
            }
        }
    }

    private void tickTrainDisplay() {
        if (this.getImminent() == null) {
            this.displayedTrain = new WeakReference<Object>(null);
            this.quitAssembly.field_22763 = true;
            this.iconTypeScroll.field_22764 = false;
            this.iconTypeScroll.field_22763 = false;
            this.toggleAssemblyButton.setToolTip((class_2561)CreateLang.translateDirect("station.assemble_train", new Object[0]));
            this.toggleAssemblyButton.setIcon(AllGuiTextures.I_ASSEMBLE_TRAIN);
            this.toggleAssemblyButton.withCallback(() -> this.field_22787.field_1724.field_3944.method_52787((class_2596)StationEditPacket.tryAssemble(this.blockEntity.method_11016())));
        } else {
            this.field_22787.field_1724.field_3944.method_52787((class_2596)StationEditPacket.configure(this.blockEntity.method_11016(), false, this.station.name, null));
            this.field_22787.method_1507((class_437)new StationScreen(this.blockEntity, this.station));
        }
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        int x = this.guiLeft;
        int y = this.guiTop;
        class_5250 header = CreateLang.translateDirect("station.assembly_title", new Object[0]);
        graphics.method_51439(this.field_22793, (class_2561)header, x + this.background.getWidth() / 2 - this.field_22793.method_27525((class_5348)header) / 2, y + 4, -15850957, false);
        AssemblyException lastAssemblyException = this.blockEntity.lastException;
        if (lastAssemblyException != null) {
            class_5250 text = CreateLang.translateDirect("station.failed", new Object[0]);
            graphics.method_51439(this.field_22793, (class_2561)text, x + 97 - this.field_22793.method_27525((class_5348)text) / 2, y + 47, -8955045, false);
            int offset = 0;
            if (this.blockEntity.failedCarriageIndex != -1) {
                graphics.method_51439(this.field_22793, (class_2561)CreateLang.translateDirect("station.carriage_number", this.blockEntity.failedCarriageIndex), x + 30, y + 67, -8750470, false);
                offset += 10;
            }
            graphics.method_51440(this.field_22793, (class_5348)lastAssemblyException.component, x + 30, y + 67 + offset, 134, -8955045, false);
            graphics.method_51440(this.field_22793, (class_5348)CreateLang.translateDirect("station.retry", new Object[0]), x + 30, y + 67 + (offset += this.field_22793.method_1728((class_5348)lastAssemblyException.component, 134).size() * 9 + 5), 134, -8750470, false);
            return;
        }
        int bogeyCount = this.blockEntity.bogeyCount;
        class_5250 text = CreateLang.translateDirect(bogeyCount == 0 ? "station.no_bogeys" : (bogeyCount == 1 ? "station.one_bogey" : "station.more_bogeys"), bogeyCount);
        graphics.method_51439(this.field_22793, (class_2561)text, x + 97 - this.field_22793.method_27525((class_5348)text) / 2, y + 47, -8750470, false);
        graphics.method_51440(this.field_22793, (class_5348)CreateLang.translateDirect("station.how_to", new Object[0]), x + 28, y + 62, 134, -8750470, false);
        graphics.method_51440(this.field_22793, (class_5348)CreateLang.translateDirect("station.how_to_1", new Object[0]), x + 28, y + 94, 134, -8750470, false);
        graphics.method_51440(this.field_22793, (class_5348)CreateLang.translateDirect("station.how_to_2", new Object[0]), x + 28, y + 117, 138, -8750470, false);
    }

    @Override
    public void method_25432() {
        super.method_25432();
        Train train = (Train)this.displayedTrain.get();
        if (train != null) {
            class_2960 iconId = this.iconTypes.get(this.iconTypeScroll.getState());
            train.icon = TrainIconType.byId(iconId);
            this.field_22787.field_1724.field_3944.method_52787((class_2596)new TrainEditPacket(train.id, "", iconId, train.mapColorIndex));
        }
    }

    @Override
    protected PartialModel getFlag(float partialTicks) {
        return AllPartialModels.STATION_ASSEMBLE;
    }
}

